<?php
/**************************************************************
* Nome:    CCRelat
* Autor:   Renato N. Lourenço
* Data:      2015-01-05 (V1.0.0)
* Descr.:  Relatorios
*************************************************************/


/**************************************************************
Area dos includes
*************************************************************/
$DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
include_once($DirRaiz.'config.php');
include_once($DirRaiz.'config.cc.php');
$Modulo = $DirCCen;
include_once($DirRaiz.$Modulo.$DirClass.'monitor.class.php');
include_once($DirRaiz.$DirModul.'geral.modu.php');
include_once($DirRaiz.$Modulo.$DirModul.'ccger.modu.php');


/**************************************************************
Definicao de variaveis
*************************************************************/
$Moni  = new Monitores;  // Objeto monitor
$L_var = $_POST;         // Recebe as variaveis do formulario

/**************************************************************
Programa Principal
*************************************************************/
$Arquivo = brancos_por_sublinhado($L_var['t'].' '.$L_var['m'].'.xls');
$Arqu    = cria_arquivo_excel($Arquivo);
for ($x=0; $x<$L_var['tg']; $x++) $LQualificacoes[$x] = $L_var['g'.$x];
$Imprime =  planilha_qualificacoes($LQualificacoes,$L_var['d'],$L_var['a'],$L_var['tp'],'xls');
echo planilha_qualificacoes($LQualificacoes,$L_var['d'],$L_var['a'],$L_var['tp'],'html')."<br/><br/>";
if ($Arqu) {
	fwrite($Arqu, $Imprime);
	fecha_arquivo_excel($Arqu);
}
return;

function planilha_qualificacoes($qualificacoes, $inicio, $fim, $tipo_periodo, $formato){
    global $Moni;
    //Arrumada as datas para timestamp
    list ($data_d, $horario_d) = explode (' ', $inicio); list ($dia_d, $mes_d, $ano_d) = explode ('/', $data_d); list ($hora_d, $minuto_d) = explode (':', $horario_d);
    if($dataAtual == $data_d) $hoje = 1;
    list ($data_a, $horario_a) = explode (' ', $fim); list ($dia_a, $mes_a, $ano_a) = explode ('/', $data_a); list ($hora_a, $minuto_a) = explode (':', $horario_a);
    if(($dataAtual != $data_a) || ($hoje != 1)) $hoje = 0;
    $Auy_d = mktime($hora_d, $minuto_d, 0, $mes_d, $dia_d, $ano_d); // $Aux_d = $ano_d.'-'.$mes_d.'-'.$dia_d.' '.$hora_d.':'.$minuto_d;
    $Auy_a = mktime($hora_a, $minuto_a, 0, $mes_a, $dia_a, $ano_a); // $Aux_a = $ano_a.'-'.$mes_a.'-'.$dia_a.' '.$hora_a.':'.$minuto_a;
    if (!($Auy_d) || ($Auy_d<0)) return "Período inválido";
    if (!($Auy_a) || ($Auy_a<0)) return "Período inválido";
    if ($Auy_d > $Auy_a) return "Per&icute;odo in&acute;lido";
    $Aux_d = $ano . '-' . $mes . '-' . $dia . ' ' . $hora . ':' . $minuto;
    $Aux_a = $ano . '-' . $mes . '-' . $dia . ' ' . $hora . ':' . $minuto;

    $dados['Total'] = 0;
    for($i = 0; $i < count($qualificacoes); $i++){
        $dados[$qualificacoes[$i]] = $Moni->gerar_relatorio_qualificacoes($inicio, $fim, $qualificacoes[$i]);
        $dados["Total"] += count($dados[$qualificacoes[$i]]['Detalhes']);
    }
    
    $Saida  = '';
    if ($formato=="html") {
        $Saida .= '<p class="reltit">Relat&oacute;rio de Qualifica&ccedil;&otilde;es'."</p>\n";
        $Saida .= '<p class="relper">Per&iacute;odo: &nbsp;&nbsp;'.substr($inicio,0,16).'&nbsp;&nbsp;&nbsp;>>>&nbsp;&nbsp;&nbsp;'.substr($fim,0,16)."</p>\n";
    } elseif ($formato=="xls") {
        $Saida .= '<table x:str border=0 cellpadding=0 cellspacing=0 style="border-collapse: collapse;table-layout:fixed;">';
        $Saida .= '<tr><td class=xl24 width=64 colspan="3">';
        $Saida .= 'Relat&oacute;rio de Qualifica&ccedil;&otilde;es';
        $Saida .= '</td></tr><tr><td class=xl24 width=64 colspan="3">';
        $Saida .= 'Per&iacute;odo: &nbsp;&nbsp;'.substr($inicio,0,16).'&nbsp;&nbsp;&nbsp;>>>&nbsp;&nbsp;&nbsp;'.substr($fim,0,16);
        $Saida .= '</td></tr>';
    }
    $Saida .= monta_relatorio_planilha_qualificacoes($qualificacoes,$dados,$formato);
    if ($formato=="xls") $Saida .= '<tr><td class=xl24 width=64></td></tr><tr><td class=xl24 width=64></td></tr>';
    return $Saida;
}

function monta_relatorio_planilha_qualificacoes($qualificacoes, $dados, $formato){
    $saida = "";
    if ($formato=="html") $saida .= '<table class="relat"><tr><td class="relatT">';
    if ($formato=="xls")  $saida .= '<tr><td class=xl24 width=64>';
    $saida .= '&nbsp;</td>';
    for($i = 0; $i < count($qualificacoes); $i++){
        if($formato=="html") $saida .= '<td class="relatT">'.$qualificacoes[$i].'</td>';
        if($formato=="xls") $saida .= '<td class=xl24 width=64>'.$qualificacoes[$i].'</td>';
    }
    if($formato=="html") $saida .= '<td class="relatT">Total</td>';
    if($formato=="xls") $saida .= '<td class=xl24 width=64>Total</td>';
    $saida .= '</tr>';
    if ($formato=="html") $saida .= '<tr><td class="relatT">';
    if ($formato=="xls")  $saida .= '<tr><td class=xl24 width=64>';
    $saida .= 'Quantidade</td>';
    for($i = 0; $i < count($qualificacoes); $i++){
        if($formato=="html") $saida .= '<td class="relat">'.count($dados[$qualificacoes[$i]]['Detalhes']).'</td>';
        if($formato=="xls") $saida .= '<td class=xl24 width=64>'.count($dados[$qualificacoes[$i]]['Detalhes']).'</td>';
        $totalQtd += count($dados[$qualificacoes[$i]]['Detalhes']);
    }
    if($formato=="html") $saida .= '<td class="relat">'.$totalQtd.'</td>';
    if($formato=="xls") $saida .= '<td class=xl24 width=64>'.$totalQtd.'</td>';
    $saida .= '</tr>';
    if ($formato=="html") $saida .= '<tr><td class="relatT">';
    if ($formato=="xls")  $saida .= '<tr><td class=xl24 width=64>';
    $saida .= 'Porcentagem</td>';
    for($i = 0; $i < count($qualificacoes); $i++){
        if($formato=="html") $saida .= '<td class="relat">'.number_format((count($dados[$qualificacoes[$i]]['Detalhes'])/$dados['Total'])*100, 2, ',', ' ')."%".'</td>';
        if($formato=="xls") $saida .= '<td class=xl24 width=64>'.number_format((count($dados[$qualificacoes[$i]]['Detalhes'])/$dados['Total'])*100, 2, ',', ' ')."%".'</td>';
    }
    if($formato=="html") $saida .= '<td class="relat">100%</td>';
    if($formato=="xls") $saida .= '<td class=xl24 width=64>100%</td>';
    $saida .= '</tr>';
    return $saida;
}
?>